 ; Box - draw a box by input height and width or by dragging the second corner.
 ; Copyright 1994, 1996, 2006 by Rocket Software Ltd.
 ; The Turing test is a mistake - it assumes that a human being can pass for
 ; an intelligence.
 (DEFUN C:BOX ( / blip osmo *error* aa cc bb dd htp wdthp)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq osmo (getvar "osmode"))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if osmo (setvar "osmode" osmo))
   (if blip (setvar "blipmode" blip))
   (command "undo" "end")
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Get some points.                                                      
 ; 
  (setq aa (getpoint "First corner:"))
 ; Ŀ
 ;   See if the user wants to input a second corner.                       
 ; 
  (if (setq cc (getcorner aa "\nOpposite corner or <Return> to specify: "))
     (progn
          (setq bb (cons (car cc) (cdr aa)))
          (setq dd (cons (car aa) (cdr cc)))
          (setvar "osmode" 0)
          (command "pline" aa bb cc dd "c"))
 ; Ŀ
 ;   Or get two distances.                                                 
 ; 
     (progn
          (if (or (= (type wdth) 'INT) (= (type wdth) 'REAL))
              (progn
                   (setq wdthp (getdist aa (strcat "\nWidth <"
                                                   (rtos wdth 2 2) ">: ")))
                   (if wdthp (setq wdth wdthp)))
              (setq wdth (getdist aa "\nWidth: ")))
          (if (or (and (/= (type ht) 'INT) (/= (type ht) 'REAL))
                  wdthp)
              (setq ht wdth))
          (setq htp (getdist aa (strcat "\nand height <"
                                        (rtos ht 2 2) ">: ")))
          (if htp (setq ht htp))
          (setvar "osmode" 0)
          (command "pline" aa (polar aa 0 wdth)
                              (polar (polar aa 0 wdth) (* pi 1.5) ht)
                              (polar aa (* pi 1.5) ht)
                              "c")))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))